///script debugger connect localhost 19144
import { world, system, EquipmentSlot } from "@minecraft/server";
const XP_STORAGE_CAP = 315;
function SetXp() {
}
world.sendMessage("Success, script started");
//initialize the custom components
world.beforeEvents.worldInitialize.subscribe(initEvent => {
    //Custom Item Components
    initEvent.itemComponentRegistry.registerCustomComponent('sky:xp_storage', {
        onUse(arg) {
            //Set using arg passed by Custom Component
            world.sendMessage(String(arg.itemStack.getDynamicProperty("a")));
            arg.itemStack.setDynamicProperty("a", 1);
            Math.random() < 0.5 ? arg.source.addExperience(1000) : arg.source.addExperience(-1000);
            arg.source.getComponent("equippable").setEquipment(EquipmentSlot.Mainhand, arg.itemStack);
            //The first time this is run the dynamic property shouldn't be sent
            //However, the second time should send "1"
        }
    });
    initEvent.itemComponentRegistry.registerCustomComponent('sky:birdview', {
        onUse(arg) {
            //checks for a block 50 blocks up or else the 50th air block
            world.sendMessage("Activated");
            if (arg.source.getItemCooldown("camera") > 0) {
                world.sendMessage("Item's on Cooldown");
            }
            else {
                world.sendMessage("Item's not on Cooldown");
            }
            arg.source.startItemCooldown("camera", 165);
            let birdview = arg.source?.getHeadLocation();
            let highblock = arg.source?.dimension.getBlockAbove(birdview, { maxDistance: 50 });
            if (highblock === undefined) {
                birdview = arg.source?.dimension.getBlock({ x: birdview.x, y: birdview.y + 50, z: birdview.z });
            }
            else {
                birdview = highblock.location;
            }
            //sets the camera into birdview
            arg.source?.camera.setCamera("minecraft:free", { easeOptions: { easeTime: 3 }, location: birdview, facingEntity: arg.source });
            //clears the camera after (160/20 = 8 seconds)
            system.runTimeout(() => (arg.source?.camera.clear()), 160);
        }
    });
    //Custom Block Components
    initEvent.blockComponentRegistry?.registerCustomComponent('sky:touch', {
        onPlayerInteract(arg) {
            //checks for a block 50 blocks up or else the 50th air block
            let birdview = arg.player?.getHeadLocation();
            let highblock = arg.player?.dimension.getBlockAbove(birdview, { maxDistance: 50 });
            if (highblock === undefined) {
                birdview = arg.player?.dimension.getBlock({ x: birdview.x, y: birdview.y + 50, z: birdview.z });
            }
            else {
                birdview = highblock.location;
            }
            //sets the camera into birdview
            arg.player?.camera.setCamera("minecraft:free", { easeOptions: { easeTime: 3 }, location: birdview, facingEntity: arg.player });
            //clears the camera after (160/20 = 8 seconds)
            system.runTimeout(() => (arg.player.camera.clear()), 400);
        }
    });
    initEvent.blockComponentRegistry?.registerCustomComponent('sky:dungeonloot', {
        onPlayerInteract(arg) {
            arg.player.applyKnockback(3, 3, 3, 3);
        }
    });
});
world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockComponentRegistry?.registerCustomComponent('sky:dungeonloot', {
        onPlayerInteract(arg) {
            arg.player.applyKnockback(3, 3, 3, 3);
        }
    });
});
//
world.sendMessage("Success Script Finished");
//  Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope Process
